// @flow
'use strict';

import * as React from 'react';

import {Offer} from '../Offer/Offer';
import {OfferStages} from '../OfferStages/OfferStages';

import {ColumnLayout} from '../../components/ColumnLayout/ColumnLayout';

type PropsT = {
    className?: string,
};

export class OfferContent extends React.Component<PropsT> {
    render(): React.Element<*> {
        const {className} = this.props;

        return (
            <ColumnLayout
                className={className}
                leftChild={(<Offer />)}
                rightChild={(<OfferStages />)}
            />
        );
    }
}
