// @flow
'use strict';

import {connect} from 'react-redux';

import {Stages} from '../../components/Stages/Stages';
import {getSupportUrl} from '../../lib/utils';

import type {ApplicationStateT} from '../../types/state';
import type {PropsT as StagesPropsT} from '../../components/Stages/Stages';

export const OfferStages = connect(
    function mapStateToProps(state: ApplicationStateT): StagesPropsT {
        const {remote: {headings}} = state;
        const supportUrl = getSupportUrl();

        if (!headings) {
            return {stages: [], supportUrl};
        }

        const headdingStages = headings.map(value => ({
            name: value,
            checked: false,
        }));

        return {
            stages: headdingStages,
            supportUrl,
        };
    },
)(Stages);
