// @flow
'use strict';

const {assign} = Object;
import * as React from 'react';

export function withDefaultProps(WrappedComponent: React.ComponentType<*>, defaultProps: Object) {
    return class extends React.Component<*> {
        render() {
            const props = assign({}, defaultProps, this.props);

            return <WrappedComponent {...props} />;
        }
    };
}
