const {snakeCase} = require('lodash');
import type {StoreT, StoreFieldT} from '../types/state';

export type OperatorT = 'AND' | 'OR' | 'NOT';

// Функция для поиска значения поля из стора, в списке ожидаемых значений
// dependencies - это ЧАСТЬ всех зависимостей, одно поле
function matchValue(store: StoreT, value: string | string[], key: string): boolean {
    // ключи в сторе Анкеты хранятся в snake_case
    const storeField: StoreFieldT = store[snakeCase(key)];
    const {$$value: storeValue} = storeField;

    const desiredValues = Array.isArray(value)
        ? value
        : [value];

    return desiredValues.includes(storeValue);
}

export function evalCondition(
    store: StoreT,
    dependencies: {[key: string]: *},
    operator: OperatorT = 'AND',
): boolean {
    const keys = Object.keys(dependencies);

    let result;

    for (let i = 0; i < keys.length; i++) {
        const key = keys[i];

        if (key === 'OR') {
            result = evalCondition(store, dependencies[key], 'OR');
        } else if (key === 'AND') {
            result = evalCondition(store, dependencies[key], 'AND');
        } else if (key === 'NOT') {
            result = !evalCondition(store, dependencies[key], 'AND');
        } else {
            result = matchValue(store, dependencies[key], key);
        }

        if (operator === 'AND') {
            if (!result) {
                return false;
            }
        }

        if (operator === 'OR') {
            if (result) {
                return true;
            }
        }
    }

    return Boolean(result);
}
