// @flow
'use strict';

type LocationT = {
    host: string,
    hostname: string,
    href: string,
    pathname: string,
    reload: Function,
};

export function getLocation(): LocationT {
    return window.location;
}

export function getReload(): Function {
    const location = getLocation();

    return location.reload.bind(location);
}

export function navigate(url: string): void {
    window.location = url;
}

export function getYandexTld(): string {
    const hostname = getLocation().hostname;

    return hostname.substr(hostname.indexOf('yandex'));
}
