interface counterConfig {
    id: string;
    params?: Record<string, any>;
}

export function reachGoal(counterConfigs: counterConfig[]): Promise<void[]> {
    const promises: Array<Promise<void> | undefined> = counterConfigs.map(({id, params}) => {
        const counter = window[`yaCounter${id}`];

        if (counter) {
            return new Promise(resolve => {
                counter.reachGoal('SubmitClick', params, () => {
                    resolve();
                });
            });
        }

        return undefined;
    });

    const hasNotEmptyPromise = promises.find(promise => promise !== undefined);

    if (hasNotEmptyPromise !== undefined) {
        return Promise.all(promises);
    }

    return Promise.reject(new Error('Has no any counter'));
}
