// @flow
'use strict';

import {getLocation, getYandexTld} from '../lib/location';

import type {UserDataT} from '../types/state';

export function getPassportRedirectUrl(
    pathname: string = '/auth',
    queryParams?: Object,
): string {
    const yandexHost = getYandexTld();
    const passportHost = `passport.${yandexHost}`;
    const url = new URL(`https://${passportHost}`);

    url.pathname = pathname;

    const retpath = getLocation().href;
    url.searchParams.set('retpath', retpath);
    if (queryParams) {
        Object.entries(queryParams).forEach(
            ([key, value]) => url.searchParams.set(key, String(value)),
        );
    }
    return url.toString();
}

export function getPostRegistrationUrl(): string {
    return getPassportRedirectUrl('/passport', {
        mode: 'postregistration',
        create_login: '1',
    });
}

export function shouldRedirectUser(userData: ?UserDataT): boolean {
    if (!userData) {
        return false;
    }

    if (userData.canFillForm) {
        return false;
    }

    const {
        hasRoleInPartner2,
        canFillFormReason,
    } = userData;

    return hasRoleInPartner2 || canFillFormReason === 'need_postregistration';
}
