'use strict';

const createHash = require('crypto').createHash;
const format = require('util').format;

exports.getAuthSecretKey = getAuthSecretKey;
exports.getNotAuthSecretKey = getNotAuthSecretKey;
exports.getHash = getHash;

/* istanbul ignore next: тесты на эту функцию устаревают каждый день */
/**
 * _getDays
 *
 * @return {number} Количество дней с начала Юникс-эпохи
 */
function _getDays() {
    return parseInt(new Date().getTime() / (1000 * 60 * 60 * 24), 10);
}

/**
 * getHash
 *
 * @param {string} str Сторка
 * @return {string} md5-хэш строки
 */
function getHash(str) {
    const hash = createHash('md5');
    hash.update(str);
    return hash.digest('hex');
}

/**
 * getAuthSecretKey
 *
 * @see https://wiki.yandex-team.ru/AlekseyPonomarev/secret-key/#format
 * @param {string} uid UID пользователя
 * @param {number} days Количество дней с начала Юникс-эпохи
 * @return {string} Секретный ключ для аутентифицированного пользователя
 */
function getAuthSecretKey(uid, days) {
    days = days || /* istanbul ignore next: устаревают каждый день */ _getDays();
    return 'u' + getHash(format('%s::%s', uid, days));
}

/**
 * getNotAuthSecretKey
 *
 * @param {string} yandexuid Значение куки yandexuid
 * @param {number} days Количество дней с начала Юникс-эпохи
 * @return {string} Секретный ключ для неаутентифицированного пользователя
 */
function getNotAuthSecretKey(yandexuid, days) {
    days = days || /* istanbul ignore next: устаревают каждый день */ _getDays();
    return 'y' + getHash(format('0:%s:%s', yandexuid, days));
}
