// @flow
'use strict';

const {assign} = Object;

export const LANG_KEY = 'lang';

export function getQueryLanguage(): string | null {
    const searchItems = window.location.search
        .slice(1)
        .split('&');

    for (const item of searchItems) {
        const [key, value] = item.split('=');

        if (key === LANG_KEY) {
            return value;
        }
    }

    return null;
}

export function updateUrlSearchPart(url: string, args: Object): string {
    const [head, ...searchParts] = url.split('?');
    const search = searchParts.join('?');

    let searchKeys = {};

    if (searchParts.length > 0) {
        searchKeys = search.split('&').reduce((acc, item) => {
            const [key, value] = item.split('=');

            acc[key] = value;

            return acc;
        }, searchKeys);
    }

    const mergedKeys = assign({}, searchKeys, args);

    const serializedKeys = Object.keys(mergedKeys)
        .map(key => key && mergedKeys[key] && `${key}=${mergedKeys[key]}`)
        .join('&');

    return [head, serializedKeys].join('?');
}
