// @flow
'use strict';

const {assign} = Object;

const {genericId} = require('teatime-components/lib/identity');

import {
    PUSH_ERROR_ACTION,
    REMOVE_ERROR_ACTION,
} from '../actions';

import type {ApplicationStateT} from '../types/state';

import type {
    PushErrorActionT,
    RemoveErrorActionT,
} from '../actions';

export const errorsReducer = {
    [PUSH_ERROR_ACTION]: (state: ApplicationStateT, action: PushErrorActionT): ApplicationStateT => {
        const {local} = state;
        const {errorStack = []} = local;
        const {payload: {error}} = action;

        const errorWithId = {
            id: genericId(),
            error,
        };

        const nextLocal = assign({}, local, {errorStack: errorStack.concat(errorWithId)});

        return assign({}, state, {local: nextLocal});
    },

    [REMOVE_ERROR_ACTION]: (state: ApplicationStateT, action: RemoveErrorActionT): ApplicationStateT => {
        const {local} = state;
        const {errorStack = []} = local;
        const {payload: {id}} = action;

        const nextErrorStack = errorStack.filter(error => error.id !== id);

        const nextLocal = assign({}, local, {errorStack: nextErrorStack});

        return assign({}, state, {local: nextLocal});
    },
};
