// @flow
'use strict';

import {composeReducers} from '../lib/reducers';

import {treeReducer} from './treeReducer';
import {fieldsReducer} from './fieldsReducer';
import {errorsReducer} from './errorsReducer';
import {miscReducer} from './miscReducer';

import type {ActionT} from '../actions';
import type {ApplicationStateT} from '../types/state';
const {INITIAL_STATE} = require('../simple/reducers/simpleFormReducer.ts');

export type SingleActionReducerT<T, P> = (state: ApplicationStateT, action: ActionT<T, P>) => ApplicationStateT;
export type SimpleReducerT<T, P> = (state: ApplicationStateT, action: ActionT<T, P>) => ApplicationStateT;

export type ComposableReducerT = {
    [actionType: string]: SingleActionReducerT<*, *>,
};

const initialState: ApplicationStateT = {
    local: {},
    remote: {},
    store: {},
    router: {},
    simpleForm: INITIAL_STATE,
};

// Order of reducers is important!!!
// $FlowFixMe: Can't find a way to make flow happy about this
const rootReducer = composeReducers(
    treeReducer,
    fieldsReducer,
    errorsReducer,
    miscReducer,
);

export {
    initialState,
    rootReducer,
};
