// @flow
'use strict';

const {assign} = Object;

import {
    LOCK_PENDING_ACTION,
    UNLOCK_PENDING_ACTION,
    RECEIVE_FIAS_ACTION,
} from '../actions';

import {camelizeObjectKeys} from '../lib/utils';

import type {ReceiveFiasActionT} from '../actions';
import type {ApplicationStateT} from '../types/state';

export const miscReducer = {
    [LOCK_PENDING_ACTION]: (state: ApplicationStateT): ApplicationStateT => {
        const {local} = state;
        const {pending = 0} = local;

        const nextLocal = assign({}, local, {pending: pending + 1});

        return assign({}, state, {local: nextLocal});
    },

    [UNLOCK_PENDING_ACTION]: (state: ApplicationStateT): ApplicationStateT => {
        const {local} = state;
        const {pending = 0} = local;

        const nextLocal = assign({}, local, {pending: pending - 1});

        return assign({}, state, {local: nextLocal});
    },

    [RECEIVE_FIAS_ACTION]: (state: ApplicationStateT, action: ReceiveFiasActionT): ApplicationStateT => {
        const {guid, data} = action.payload;
        const {remote} = state;
        const {fias = {}} = remote;

        const camelizedData = data.map(item => camelizeObjectKeys(item));

        const nextFias = assign({}, fias, {[guid]: camelizedData});
        const nextRemote = assign({}, remote, {fias: nextFias});

        return assign({}, state, {remote: nextRemote});
    },
};
