import React from 'react';
import {Redirect, Route, Switch} from 'react-router';
import {ConnectedRouter} from 'react-router-redux';
import {connect} from 'react-redux';

const {FormPage} = require('./containers/FormPage/FormPage');
const {FormContent} = require('./containers/FormContent/FormContent');
const {OfferContent} = require('./containers/OfferContent/OfferContent');

import type {History} from 'history';
import {isSimpleFormSelector} from './selectors/remote';
import {SimpleFormPageContainer} from './simple/containers/SimpleFormPageContainer';
import {ApplicationStateT} from './types/state';

interface RoutesStateProps {
    isSimpleForm: boolean,
}

interface RoutesOwnProps {
    history: History,
}

type RoutesProps = RoutesStateProps & RoutesOwnProps;

class RoutesComponent extends React.Component<RoutesProps> {
    render(): React.ReactNode {
        const {history} = this.props;

        return (
            <ConnectedRouter history={history}>
                {this.renderApp()}
            </ConnectedRouter>
        );
    }

    renderApp(): React.ReactNode {
        const {isSimpleForm} = this.props;

        const formComponent = isSimpleForm ? SimpleFormPageContainer : FormContent;

        return (
            <FormPage>
                <Switch>
                    <Redirect exact from='/' to='/form' />
                    <Route exact path='/form/offer' component={OfferContent} />
                    <Route path='/form' component={formComponent} />
                </Switch>
            </FormPage>
        );
    }
}

function mapStateToProps(state: ApplicationStateT, ownProps: RoutesOwnProps): RoutesProps {
    return {
        history: ownProps.history,
        isSimpleForm: isSimpleFormSelector(state),
    };
}

export const Routes = connect(mapStateToProps)(RoutesComponent);
