// @flow
'use strict';

import type {ChangeLocaleActionT} from '../actions';

import {getLocation, getYandexTld, navigate} from '../lib/location';
import {call, select} from 'redux-saga/effects';
import {selectSecretKey} from '../selectors/util';
import url from 'url';

export default function* changeLocaleSaga(action: ChangeLocaleActionT): Generator<*, *, *> {
    const {payload: {locale: intl} = {}} = action;
    const retpath = encodeURI(getLocation().href);
    const sk = yield select(selectSecretKey);

    const tuneHost = yield call(getYandexTld);
    const tuneUrl = url.format({
        host: tuneHost,
        pathname: '/portal/set/lang/',
        query: {intl, retpath, sk},
    });

    yield call(navigate, tuneUrl);
}
