// @flow
'use strict';

import {select} from 'redux-saga/effects';

import {selectLanguage} from '../selectors/remote.ts';
import {DEFAULT_LANGUAGE, LANGS} from '../lib/i18n';

import {LANG_KEY, getQueryLanguage, updateUrlSearchPart} from '../lib/url';

export default function* checkLanguageSaga(): Generator<*, *, *> {
    const lang = yield select(selectLanguage);

    if (!lang) {
        return;
    }

    let queryLang = getQueryLanguage();

    if (!LANGS.includes(queryLang)) {
        queryLang = DEFAULT_LANGUAGE;
    }

    if (lang !== queryLang) {
        const url = window.location.href;
        const newUrl = updateUrlSearchPart(url, {[LANG_KEY]: lang});
        window.location = newUrl;
    }
}
