// @flow
'use strict';

import {put} from 'redux-saga/effects';

import {
    setFieldError,
    FILE_UPLOAD_FIELD_ADD_ACTION,
    FILE_UPLOAD_FIELD_DELETE_ACTION,
} from '../actions';

import type {
    FieldFocusActionT,
    FileUploadFieldAddActionT,
    FileUploadFieldDeleteActionT,
} from '../actions';

export default function* clearFieldErrorSaga(
    action: FieldFocusActionT | FileUploadFieldAddActionT | FileUploadFieldDeleteActionT
): Generator<*, *, *> {
    let id;

    if (action.type === FILE_UPLOAD_FIELD_ADD_ACTION || action.type === FILE_UPLOAD_FIELD_DELETE_ACTION) {
        const {payload: {fieldId}} = action;
        id = fieldId;
    } else {
        const {payload: {id: fieldId}} = action;
        id = fieldId;
    }

    yield put(setFieldError(id, null));
}
