// @flow
'use strict';

import {call, put, select} from 'redux-saga/effects';

import {fetchJSON} from '../lib/fetch';
import {getDefaultsByType} from '../lib/fields';

import {selectProjectId} from '../selectors';

import {
    selectBranchUrl,
} from '../selectors/url';

import {
    initStore,
    receiveBranch,
} from '../actions';

import type {
    BranchChangeActionT,
    FetchBranchActionT,
} from '../actions';

import {setPending} from '../simple/actions/SimpleFormActions.ts';

export default function* fetchBranchAndOfferSaga(action: BranchChangeActionT | FetchBranchActionT): Generator<*, *, *> {
    const {branchId} = action.payload;

    if (!branchId) {
        return;
    }

    const projectId = yield select(selectProjectId);
    const branchUrl = yield select(selectBranchUrl, branchId, projectId);

    yield put(setPending(true));
    const response = yield call(fetchJSON, branchUrl);

    if (!response.ok) {
        console.error(`Failed to fetch branch: ${response.error}`);
        yield put(setPending(false));
        return;
    }

    yield put(receiveBranch({data: response.data}));
    yield put(setPending(false));

    const defaults = yield select(getDefaultsByType);

    yield put(initStore(defaults));
}
