// @flow
'use strict';

import {call, put, select} from 'redux-saga/effects';

import {fetchJSON} from '../lib/fetch';

import {
    selectFiasQueryUrl,
} from '../selectors/url';

import {
    selectFiasByGuid,
} from '../selectors/remote.ts';

import {
    receiveFias,
    setFieldPending,
} from '../actions';

import type {FetchFiasActionT} from '../actions';

export default function* fiasQuerySaga(action: FetchFiasActionT): Generator<*, *, *> {
    const {payload: {guid, fieldId}} = action;

    const fiasList = yield select(selectFiasByGuid, guid);

    if (fiasList !== null) {
        return;
    }

    if (fieldId) {
        yield put(setFieldPending(fieldId, true));
    }

    const fiasQueryUrl = yield select(selectFiasQueryUrl, guid);

    const response = yield call(fetchJSON, fiasQueryUrl);
    const {ok} = response;

    if (ok) {
        const {data: {data}} = response;

        if (data) {
            yield put(receiveFias(guid || 'ROOT', data));
        }
    }

    if (fieldId) {
        yield put(setFieldPending(fieldId, false));
    }
}
