// @flow
'use strict';

import {put, take} from 'redux-saga/effects';

import {
    setFieldFocus,
    FIELD_BLUR_ACTION,
} from '../actions';

import type {FieldFocusActionT} from '../actions';

export default function* fieldFocusSaga(action: FieldFocusActionT): Generator<*, *, *> {
    const {payload: {id}} = action;

    yield put(setFieldFocus(id, true));

    yield take(action => action.type === FIELD_BLUR_ACTION && action.payload.id === id);

    yield put(setFieldFocus(id, false));
}
