// @flow
'use strict';

import {call, put, select} from 'redux-saga/effects';
import Raven from 'raven-js';

import {uploadFile} from '../lib/fetch';

import {
    selectUploadFileUrl,
} from '../selectors/url';

import {
    fileUploadFieldFinished,
} from '../actions';

import type {FileUploadFieldAddActionT} from '../actions';

export default function* fileUploadSaga(action: FileUploadFieldAddActionT): Generator<*, *, *> {
    const {payload: {fieldId, fileId, file}} = action;

    const uploadFileUrl = yield select(selectUploadFileUrl);

    const response = yield call(uploadFile, uploadFileUrl, file);
    const {ok, data: {key} = {key: null}} = response;

    if (!ok) {
        Raven.captureMessage('File upload error', {
            extra:
                {
                    request: {fileId},
                    response,
                },
        });
    }

    yield put(fileUploadFieldFinished(fieldId, fileId, ok, key));
}
