// @flow
'use strict';

import 'regenerator-runtime/runtime';

import {takeEvery, takeLatest, fork} from 'redux-saga/effects';

import {
    BRANCH_CHANGE_ACTION,
    CHANGE_LOCALE_ACTION,
    COUNTRY_CHANGE_ACTION,
    FETCH_TREE_ACTION,
    FETCH_FIAS_ACTION,
    FIELD_BLUR_ACTION,
    FIELD_FOCUS_ACTION,
    FILE_UPLOAD_FIELD_ADD_ACTION,
    FILE_UPLOAD_FIELD_DELETE_ACTION,
    SUBMIT_ACTION,
    RECEIVE_USER_DATA_ACTION,
} from '../actions';

import clearFieldErrorSaga from './clearFieldErrorSaga';
import fetchBranchAndOfferSaga from './fetchBranchAndOfferSaga';
import fetchTreeSaga from './fetchTreeSaga';
import fieldFocusSaga from './fieldFocusSaga';
import submitSaga from './submitSaga';
import validateFieldSaga from './validateFieldSaga';
import changeLocaleSaga from './changeLocaleSaga';
import fileUploadSaga from './fileUploadSaga';
import resetFormSaga from './resetFormSaga';
import fiasQuerySaga from './fiasQuerySaga';
import {simpleFormSaga} from '../simple/sagas/simpleFormSaga.ts';
import {receiveUserDataSaga} from './receiveUserDataSaga.ts';

export default function* rootSaga(): Generator<*, *, *> {
    yield takeLatest(FETCH_TREE_ACTION, fetchTreeSaga);
    yield takeLatest(COUNTRY_CHANGE_ACTION, resetFormSaga);
    yield takeLatest(BRANCH_CHANGE_ACTION, fetchBranchAndOfferSaga);
    yield takeLatest(SUBMIT_ACTION, submitSaga);
    yield takeEvery(FIELD_BLUR_ACTION, validateFieldSaga);
    yield takeEvery(FILE_UPLOAD_FIELD_ADD_ACTION, clearFieldErrorSaga);
    yield takeEvery(FILE_UPLOAD_FIELD_DELETE_ACTION, clearFieldErrorSaga);
    yield takeEvery(FIELD_FOCUS_ACTION, clearFieldErrorSaga);
    yield takeEvery(FIELD_FOCUS_ACTION, fieldFocusSaga);
    yield takeEvery(CHANGE_LOCALE_ACTION, changeLocaleSaga);
    yield takeEvery(FILE_UPLOAD_FIELD_ADD_ACTION, fileUploadSaga);
    yield takeEvery(FETCH_FIAS_ACTION, fiasQuerySaga);
    yield takeEvery(RECEIVE_USER_DATA_ACTION, receiveUserDataSaga);
    yield fork(simpleFormSaga);
}
