import {SagaIterator} from 'redux-saga';
import {call, select} from 'redux-saga/effects';
import {selectVersion, SIMPLE_FORM_VERSION} from '../selectors/remote';
const {selectMainFormUrl} = require('../selectors/url');
const {navigate} = require('../lib/location');
const {
    MOBILE_MEDIATION_PROJECT_ID,
    selectProjectId,
    VIDEO_BLOGGER_PROJECT_ID,
    EFIR_BLOGGER_PROJECT_ID,
} = require('../selectors');

export function* receiveUserDataSaga(): SagaIterator {
    const state = yield select();
    const formVersion = selectVersion(state);

    // Делаем редиректы со старых форм только для упрощенной формы
    if (formVersion !== SIMPLE_FORM_VERSION) {
        return;
    }

    const projectId = selectProjectId(state);

    // Для асессоров и игр (GAMES_PROJECT_ID || ASSESSOR_PROJECT_ID) оставляем старый путь
    const needRedirectToDefaultForm = projectId === MOBILE_MEDIATION_PROJECT_ID ||
        projectId === VIDEO_BLOGGER_PROJECT_ID ||
        projectId === EFIR_BLOGGER_PROJECT_ID;

    if (!needRedirectToDefaultForm) {
        return;
    }

    const mainFormUrl = selectMainFormUrl(state);
    yield call(navigate, mainFormUrl);
}
