// @flow
'use strict';

import {call, put, select} from 'redux-saga/effects';

import {postJSON} from '../lib/fetch';

import {
    selectSubmitOfferUrl,
} from '../selectors/url';

import {selectOfferId} from '../selectors/remote.ts';

import {
    lockPending,
    unlockPending,
} from '../actions';

export default function* submitFormSaga(): Generator<*, *, *> {
    yield put(lockPending());

    const offerId = yield select(selectOfferId);
    const submitOfferUrl = yield select(selectSubmitOfferUrl, offerId);

    const response = yield call(postJSON, submitOfferUrl);

    if (response.ok) {
        // yield put(redirectToPi());
    } else {
        const {data: {error_message: errorMessage}} = response;

        if (errorMessage) {
            console.error(errorMessage);
        }
    }

    yield put(unlockPending());
}
