// @flow
'use strict';

import {call, select} from 'redux-saga/effects';

import {
    selectPageId,
} from '../selectors';

import {
    OFFER_PAGE_ID,
} from '../selectors';

import submitFormSaga from './submitFormSaga';
import submitOfferSaga from './submitOfferSaga';

export default function* submitSaga(): Generator<*, *, *> {
    const page = yield select(selectPageId);

    if (page === OFFER_PAGE_ID) {
        yield call(submitOfferSaga);
    } else {
        yield call(submitFormSaga);
    }
}
