const {DEFAULT_LANGUAGE} = require('../lib/i18n');

import {
    ApplicationStateT,
    FiasT,
    UserDataT,
} from '../types/state';

export const OLD_FORM_VERSION = 1;
export const SIMPLE_FORM_VERSION = 2;

export function selectLanguage(state: ApplicationStateT): string | null {
    const {remote: {user}} = state;

    if (!user) {
        return DEFAULT_LANGUAGE;
    }

    const {language} = user;

    return language;
}

export function selectOfferId(state: ApplicationStateT): string | null {
    const {local, remote} = state;
    const {countryId, branchId} = local;
    const {tree} = remote;

    if (!countryId || !branchId) {
        return null;
    }

    if (!tree) {
        return null;
    }

    const countryData = tree[countryId];
    const branch = countryData.branches[branchId];
    const {ofertaId} = branch;

    if (!ofertaId) {
        return null;
    }

    return ofertaId;
}

export function selectFiasByGuid(state: ApplicationStateT, guid: string | null): FiasT[] | null {
    const {remote} = state;
    const {fias = {}} = remote;

    guid = guid ? guid : 'ROOT';

    return fias[guid] || null;
}

export function selectUserData(state: ApplicationStateT): UserDataT | null {
    const {remote} = state;
    const {user} = remote;

    if (!user) {
        return null;
    }

    return user;
}

export function selectVersion(state: ApplicationStateT): number {
    const user = selectUserData(state);

    return user && user.version !== undefined ? user.version : OLD_FORM_VERSION;
}

export function hasRoleInPartner2Selector(state: ApplicationStateT): boolean {
    const user = selectUserData(state);

    return user && user.hasRoleInPartner2 !== null ? user.hasRoleInPartner2 : false;
}

export function isSimpleFormSelector(state: ApplicationStateT): boolean {
    const version = selectVersion(state);
    const hasRoleInPartner2 = hasRoleInPartner2Selector(state);

    // Если пользователя еще нет в ПИ и версия анкеты = 2, то показываем упрощенную форму
    return version === SIMPLE_FORM_VERSION && !hasRoleInPartner2;
}
