// @flow
'use strict';

import {DEFAULT_PROJECT_ID} from '.';

import type {ApplicationStateT} from '../types/state';
import type {ProjectIdT} from '.';

const BASE_URL = '/form/api';
const API_VERSION = '0';

export function selectBranchUrl(state: ApplicationStateT, branchId: string, projectId?: ProjectIdT): string {
    if (projectId && projectId !== DEFAULT_PROJECT_ID) {
        return `${BASE_URL}/${API_VERSION}/branch?id=${branchId}&project=${projectId}`;
    }

    return `${BASE_URL}/${API_VERSION}/branch?id=${branchId}`;
}

export function selectCurrentUserUrl(): string {
    return `${BASE_URL}/${API_VERSION}/current_user`;
}

export function selectSubmitFormUrl(): string {
    return `${BASE_URL}/${API_VERSION}/submit`;
}

export function selectSubmitOfferUrl(state: ApplicationStateT, id: string): string {
    return `${BASE_URL}/${API_VERSION}/submit_oferta?id=${id}`;
}

export function selectTreeUrl(state?: ApplicationStateT, project?: string): string {
    if (project) {
        return `${BASE_URL}/${API_VERSION}/dispatcher?project=${project}`;
    }
    return `${BASE_URL}/${API_VERSION}/dispatcher`;
}

export function selectValidationUrl(state: ApplicationStateT, id: string, value: string): string {
    return `${BASE_URL}/${API_VERSION}/${id}?value=${value}`;
}

export function selectValidationPostUrl(state: ApplicationStateT, id: string): string {
    return `${BASE_URL}/${API_VERSION}/${id}`;
}

export function selectOfferUrl(state: ApplicationStateT, id: string, language: string): string {
    return `${BASE_URL}/${API_VERSION}/oferta?id=${id}&language=${language}`;
}

export function selectUploadFileUrl(): string {
    return `${BASE_URL}/${API_VERSION}/save_attachment`;
}

export function selectFiasQueryUrl(state: ApplicationStateT, guid: string | null): string {
    if (guid) {
        return `${BASE_URL}/${API_VERSION}/query_fias?parent_guid=${guid}`;
    }

    return `${BASE_URL}/${API_VERSION}/query_fias`;
}

export function selectMainFormUrl(): string {
    return '/form/';
}

export function selectOfferPageUrl(): string {
    return '/form/offer';
}

export function selectDashboardUrl(): string {
    return '/v2/dashboard/';
}

export function selectMobileMediationUrl(): string {
    return '/v2/mobile-mediation/';
}

export function selectRestApiSiteUrl(): string {
    return '/restapi/v1/site';
}

export function selectRestApiMobileAppUrl(): string {
    return '/restapi/v1/mobile_app';
}

export function selectRestApiContextCampaignUrl(): string {
    return '/restapi/v1/context_on_site_campaign';
}

export function selectRestApiMobileAppSettingsUrl(): string {
    return '/restapi/v1/mobile_app_settings';
}

export function selectVideoBloggerUrl(): string {
    return '/v2/dashboard/';
}

export function selectEfirBloggerUrl(): string {
    return '/v2/dashboard/';
}

export function selectGamesUrl(): string {
    return 'https://games.yandex.ru/console';
}
