// @flow
'use strict';

import type {ApplicationStateT} from '../types/state';

import {getAuthSecretKey} from '../lib/secretKey';

export function selectSecretKey(state: ApplicationStateT): string {
    const {remote} = state;
    const {user: {userId} = {userId: '0'}} = remote;

    return getAuthSecretKey(userId);
}
