import {ValidationResultT} from '../../lib/validateSimpleJsonSchema';

export const enum SIMPLE_FORM_ACTIONS {
    FIELD_VALUE_CHANGE = 'SIMPLE_FORM_ACTIONS_FIELD_VALUE_CHANGE',
    SET_FIELD_VALUE = 'SIMPLE_FORM_ACTIONS_SET_FIELD_VALUE',
    SET_FIELD_VALIDATION = 'SIMPLE_FORM_ACTIONS_SET_FIELD_VALIDATION',
    SET_BACKEND_ERRORS = 'SIMPLE_FORM_ACTIONS_SET_BACKEND_ERRORS',
    SET_PENDING = 'SIMPLE_FORM_ACTIONS_SET_PENDING',
    SUBMIT = 'SIMPLE_FORM_ACTIONS_SUBMIT',
}

export interface FieldValueChangePayload {
    name: string;
    value: any;
}

export interface FieldValidationPayload {
    name: string;
    validation: ValidationResultT;
}

type BackendErrorsPayload = Record<
    string,
    Array<{description: string}>
>;

export type simpleFormActionsTypes =
    | ReturnType<typeof fieldValueChange>
    | ReturnType<typeof setFieldValue>
    | ReturnType<typeof submit>
    | ReturnType<typeof setFieldValidation>
    | ReturnType<typeof setBackendErrors>
    | ReturnType<typeof setPending>;

export const fieldValueChange = (payload: FieldValueChangePayload) => ({
    type: SIMPLE_FORM_ACTIONS.FIELD_VALUE_CHANGE,
    payload,
} as const);

export const setFieldValue = (payload: FieldValueChangePayload) => ({
    type: SIMPLE_FORM_ACTIONS.SET_FIELD_VALUE,
    payload,
} as const);

export const submit = () => ({
    type: SIMPLE_FORM_ACTIONS.SUBMIT,
} as const);

export const setFieldValidation = (payload: FieldValidationPayload) => ({
    type: SIMPLE_FORM_ACTIONS.SET_FIELD_VALIDATION,
    payload,
} as const);

export const setBackendErrors = (payload: BackendErrorsPayload) => ({
    type: SIMPLE_FORM_ACTIONS.SET_BACKEND_ERRORS,
    payload,
} as const);

export const setPending = (payload: boolean) => ({
    type: SIMPLE_FORM_ACTIONS.SET_PENDING,
    payload,
} as const);
