import React from 'react';
import Markdown from 'markdown-to-jsx';

import {Checkbox} from '../uikit/Checkbox';
import {FieldProps} from '../../types/FieldProps';
import {CheckboxFieldConfig} from '../../types/FieldsData';

export function BooleanField(props: FieldProps<CheckboxFieldConfig>): React.ReactElement {
    const {
        data,
        onChange,
    } = props;

    const {
        name,
        label,
        value,
    } = data;

    const onChangeHandler = React.useCallback<React.ChangeEventHandler<HTMLInputElement>>(e => {
        onChange(name, e.target.checked);
    }, [onChange]);

    const labelNode = React.useMemo(() => (
        <Markdown>
            {label}
        </Markdown>
    ), [label]);

    return (
        <Checkbox
            size='m'
            label={labelNode}
            view='default'
            tone='direct'
            checked={value}
            onChange={onChangeHandler}
        />
    );
}
