import React from 'react';

import {FieldProps} from '../../types/FieldProps';
import {DateFieldConfig} from '../../types/FieldsData';
import {Lang} from '../../types/Lang';
import {isMobile} from '../../utils/isMobile';

import {DateField as DateFieldDesktop} from './DateField@desktop';
import {DateField as DateFieldMobile} from './DateField@mobile';

type DateFieldProps = FieldProps<DateFieldConfig> & {
    lang: Lang
}

export function DateField(props: DateFieldProps): React.ReactElement {
    const isMobileBrowser = React.useMemo(() => isMobile(window), []);

    return (
        <>
            {isMobileBrowser
                ? <DateFieldMobile {...props} />
                : <DateFieldDesktop {...props} />
            }
        </>
    );
}
