import {DatePicker} from '@yandex-lego/components/next/DatePicker';
import {Provider} from '@yandex-lego/components/Provider';
import moment from 'moment';
import React from 'react';
import {MAX_DATE_MOMENT} from '../../constants';
import {Lang} from '../../types/Lang';
import css from './DateField@desktop.css';
import {DateFieldProps} from './types';

const MAX_DATE = MAX_DATE_MOMENT.toDate();

export function DateField(props: DateFieldProps): React.ReactElement {
    const {
        data: {
            name,
            value,
        },
        onChange,
        lang,
    } = props;

    const lastValidDateRef = React.useRef<Date>(MAX_DATE);

    const maxDate = React.useMemo(() => MAX_DATE, []);

    const dateValue = React.useMemo(() => {
        if (!value) {
            return lastValidDateRef.current;
        }

        const newMoment = moment(value);
        if (newMoment.isValid()) {
            lastValidDateRef.current = newMoment.toDate();
        }

        return lastValidDateRef.current;
    }, [value]);

    const onChangeHandler = React.useCallback(e => {
        const newMoment = moment(e.value);
        if (newMoment.isValid()) {
            const newValue = newMoment.format('YYYY-MM-DD');
            onChange(name, newValue);
        } else {
            onChange(name, moment(lastValidDateRef.current).format('YYYY-MM-DD'));
        }
    }, [name, onChange]);

    // Для русского языка всегда выбираем русский формат даты, для всех остальных языков берем браузерный
    // Возможно сделать явную привязку к стране, но для этого нужен словарь
    const locale = React.useMemo(() => lang === Lang.russian ? 'ru-RU' : navigator.language, [lang]);

    return (
        <Provider
            locale={locale}
        >
            <DatePicker
                value={dateValue}
                onChange={onChangeHandler}
                max={maxDate}
                className={css.root}
            />
        </Provider>
    );
}
