import React, {ChangeEventHandler} from 'react';
import {DateFieldProps} from './types';

import css from './DateField@mobile.css';
import {MAX_DATE} from '../../constants';

export function DateField(props: DateFieldProps): React.ReactElement {
    const {
        data: {
            name,
            value,
        },
        onChange,
    } = props;

    const onChangeHandler = React.useCallback<ChangeEventHandler<HTMLInputElement>>(e => {
        onChange(name, e.currentTarget.value);
    }, [name, onChange]);

    return (
        <div
            className={css.root}
        >
            <div className={css.border}/>
            <input
                className={css.input}
                type='date'
                name={name}
                value={value}
                onChange={onChangeHandler}
                max={MAX_DATE}
            />
        </div>
    );
}
