import classnames from 'classnames';
import React from 'react';

import {Text} from '../uikit/Text';

import css from './FieldWrapper.css';

type FieldWrapperProps = React.PropsWithChildren<{
    label?: string;
    error?: string;
    hint?: string;
    style?: string;
}>

export function FieldWrapper(props: FieldWrapperProps): React.ReactElement {
    const {
        children,
        label,
        error,
        hint,
        style,
    } = props;

    return (
        <div
            className={classnames(css.root, {
                [css.root__short]: style === 'short',
            })}
        >
            {(label || hint) && (
                <div className={css.header}>
                    {label && (
                        <Text
                            typography='body-long-xl'
                            weight='medium'
                        >
                            {label}
                        </Text>
                    )}
                    {hint && (
                        <div className={css.hint}>
                            <Text
                                typography='body-long-xl'
                                className={css.hintText}
                            >
                                {hint}
                            </Text>
                        </div>
                    )}
                </div>
            )}
            {children}
            {error &&
                <div
                    className={css.error}
                >
                    <Text
                        typography='body-long-xl'
                        color='alert'
                    >
                        {error}
                    </Text>
                </div>
            }
        </div>
    );
}
