import React from 'react';
import {FilteredSelect} from '../uikit/FilteredSelect';

import {FieldProps} from '../../types/FieldProps';
import {FilteredSelectFieldConfig} from '../../types/FieldsData';

export function FilteredSelectField(props: FieldProps<FilteredSelectFieldConfig>): React.ReactElement {
    const {
        data,
        onChange,
    } = props;

    const {
        name,
        value,
        values,
    } = data;

    const onChangeHandler = React.useCallback<React.ChangeEventHandler<HTMLSelectElement>>(e => {
        onChange(name, e.target.value);
    }, [onChange]);

    return (
        <FilteredSelect
            options={values}
            size='m'
            value={value}
            onChange={onChangeHandler}
        />
    );
}
