import React from 'react';
import {FieldData, FieldType} from '../../types/FieldsData';
import {Lang} from '../../types/Lang';
import {BooleanField} from '../BooleanField';
import {DateField} from '../DateField';
import {FilteredSelectField} from '../FilteredSelectField';
import {InputField} from '../InputField';
import {MultiselectField} from '../MultiselectField';
import {OfertaField} from '../OfertaField';
import {SelectField} from '../SelectField';
import {TextField} from '../TextField';

interface FieldControlProps {
    data: FieldData;
    hasError: boolean;
    lang: Lang;
    onChange: (fieldName: string, value: string | string[] | boolean) => void;
}

export function FieldControl(props: FieldControlProps): React.ReactElement | null {
    const {
        data,
        hasError,
        lang,
        onChange,
    } = props;

    switch (data.type) {
        case FieldType.Input:
            return (
                <InputField
                    data={data}
                    hasError={hasError}
                    onChange={onChange}
                />
            );
        case FieldType.Select:
            return (
                <SelectField
                    data={data}
                    onChange={onChange}
                />
            );
        case FieldType.FilteredSelect:
            return (
                <FilteredSelectField
                    data={data}
                    onChange={onChange}
                />
            );
        case FieldType.MultiSelect:
            return (
                <MultiselectField
                    data={data}
                    onChange={onChange}
                />
            );
        case FieldType.Boolean:
            return (
                <BooleanField
                    data={data}
                    onChange={onChange}
                />
            );
        case FieldType.Oferta:
            return (
                <OfertaField
                    data={data}
                    onChange={onChange}
                />
            );
        case FieldType.Date:
            return (
                <DateField
                    data={data}
                    lang={lang}
                    onChange={onChange}
                />
            );
        case FieldType.Text:
            return (
                <TextField
                    label={data.label}
                />
            );
        default:
            return null;
    }
}
