import React from 'react';

import {Lang} from '../../types/Lang';
import {Button} from '../uikit/Button';
import {FieldData, FieldsData, FieldType} from '../../types/FieldsData';
import {FieldWrapper} from '../FiledWrapper';
import {FieldControl} from './FieldControl';

import {GLOSSARY} from './FormGlossary';

import css from './Form.css';

interface FormProps {
    fieldsData: FieldsData;
    lang: Lang;
    submitButtonEnabled: boolean;
    onSubmit: VoidFunction;
    onFieldValueChange: (fieldName: string, value: string | string[] | boolean) => void;
}

const TYPES_WO_HEADER = [
    FieldType.Boolean,
    FieldType.Oferta,
    FieldType.Text,
];

export class Form extends React.Component<FormProps> {
    public render() {
        const {fieldsData, submitButtonEnabled} = this.props;

        return (
            <>
                {fieldsData.fields.map(data => this.renderField(data))}
                <Button
                    disabled={!submitButtonEnabled}
                    className={css.button}
                    size='m'
                    view='action'
                    onClick={this.onSubmit}
                >
                    {GLOSSARY.CONTINUE_BUTTON_LABEL}
                </Button>
            </>
        );
    }

    private onSubmit = (): void => {
        const {onSubmit} = this.props;

        onSubmit();
    }

    private renderField(data: FieldData): React.ReactNode {
        const {onFieldValueChange, lang} = this.props;
        const {
            label,
            name,
            type,
            error,
            hint,
            style,
        } = data;

        const wrapperLabel = TYPES_WO_HEADER.includes(type) ? undefined : label;

        return (
            <FieldWrapper
                key={`${name}_wrapper`}
                label={wrapperLabel}
                error={error}
                hint={hint}
                style={style}
            >
                <FieldControl
                    data={data}
                    lang={lang}
                    hasError={Boolean(error)}
                    onChange={onFieldValueChange}
                />
            </FieldWrapper>
        );
    }
}
