import React from 'react';
import cls from 'classnames';
import {User} from '../../../../../packages/partner-components';
import {LangSwitcher} from '../../LangSwitcher/LangSwitcher';
import {LogoComponent} from '../../Logo/Logo';
import {DesktopHeadProps} from './types';

import css from './Header.pcss';

export const DesktopHead = (props: DesktopHeadProps) => {
    const {
        className,
        leftElement,
        rightElement,
        userId,
        displayLogin,
        onChangeLang,
        locale,
    } = props;

    return (
        <div className={cls(css.header, className)}>
            <div className={cls(css.wrapper, css.logo)}>
                <div className={css.leftSide}>
                    {leftElement
                        ? leftElement
                        : <LogoComponent locale={locale} />
                    }
                </div>
                <div className={css.rightSide}>
                    <div className={css.additionally}>
                        <LangSwitcher
                            onChange={onChangeLang}
                            locale={locale}
                        />
                        {rightElement}
                    </div>
                    <div className={css.user}>
                        <User avatarId={userId} menuItems={[]}>{displayLogin}</User>
                    </div>
                </div>
            </div>
        </div>
    );
};
