import React from 'react';

import {Textinput} from '../uikit/Textinput';
import {FieldProps} from '../../types/FieldProps';
import {InputFieldConfig} from '../../types/FieldsData';

type InputFieldProps = FieldProps<InputFieldConfig> & {
    hasError: boolean;
};

const DEBOUNCE_TIMEOUT = 500;

export function InputField(props: InputFieldProps): React.ReactElement {
    const {
        data: {
            name,
            value,
        },
        hasError,
        onChange,
    } = props;

    const onChangeHandler = React.useCallback<React.ChangeEventHandler<HTMLInputElement>>(e => {
        onChange(name, e.target.value);
    }, [onChange]);

    return (
        <Textinput
            size='m'
            view='default'
            value={value}
            state={hasError ? 'error' : undefined}
            onChange={onChangeHandler}
            onBlur={onChangeHandler}
            debounceTimeout={DEBOUNCE_TIMEOUT}
        />
    );
}
