import * as React from 'react';
import {Link} from '../uikit/Link';

interface LabelWithMiddleLinkProps {
    url?: string;
    text: string;
    target?: string;
}

export function LabelWithMiddleLink (props: LabelWithMiddleLinkProps): React.ReactElement {
    const {
        text,
        url,
        target = '_blank',
    } = props;

    const parts = React.useMemo(() => {
        const messageRegExp = /(.*)\[linkStart](.*)\[linkEnd](.*)/;

        const results = messageRegExp.exec(text);

        if (!results || results.length !== 4) {
            return undefined;
        }

        const [, before, link, after] = results;

        return {
            before,
            link,
            after,
        };
    }, [text]);

    if (!url || !parts) {
        return (
            <span>
                {text}
            </span>
        );
    }

    const {
        before,
        link,
        after,
    } = parts;

    return (
        <span>
            {before}
            <Link
                view='default'
                href={url}
                target={target}
            >
                {link}
            </Link>
            {after}
        </span>
    );
}
