import React from 'react';
import classnames from 'classnames';

import {Button} from '../uikit/Button';
import {Lang} from '../../types/Lang';

import styles from './LangSwitcher.pcss';

const LOCALES = {
    [Lang.english]: 'English',
    [Lang.russian]: 'Русский',
};

interface LangSwitcherProps {
    locale: Lang,
    className?: string,
    onChange: (selectedLocale: Lang) => void,
}

export const LangSwitcher = (props: LangSwitcherProps) => {
    const {locale: currentLocale, onChange} = props;

    const localeToChange = currentLocale === Lang.russian
        ? Lang.english
        : Lang.russian;

    return (
        <Button
            className={styles.switcher}
            size='xs'
            view='clear'
            onClick={() => onChange(localeToChange as Lang)}
        >
            {LOCALES[localeToChange]}
            <span className={classnames(styles.flag, styles[localeToChange])}/>
        </Button>
    );
};
