import classnames from 'classnames';
import React from 'react';

import {Lang} from '../../types/Lang';

import css from './Logo.css';

import enAdvNetworkImg from './Logo__en_advNetwork.svg';
import enLogoImg from './Logo__en_yandex.svg';
import ruAdvNetworkImg from './Logo__ru_advNetwork.svg';
import ruLogoImg from './Logo__ru_yandex.svg';

export interface LogoComponentProps {
    className?: string;
    serviceUrl?: string;
    yandexUrl: string;
    locale?: Lang;
}

export class LogoComponent extends React.Component<LogoComponentProps> {
    static defaultProps = {
        serviceUrl: '/',
        yandexUrl: 'https://yandex.ru',
        locale: Lang.russian,
    }

    render() {
        const {className, serviceUrl, yandexUrl, locale} = this.props;

        const logos = locale === Lang.english
            ? {
                logo: enLogoImg,
                advNetworkImg: enAdvNetworkImg,
            }
            : {
                logo: ruLogoImg,
                advNetworkImg: ruAdvNetworkImg,
            };

        return (
            <span
                className={classnames(css.container, className)}
            >
                <a className={css.link} href={yandexUrl}>
                    <img src={logos.logo} alt='' />
                </a>
                <a className={css.link} href={serviceUrl}>
                    <img src={logos.advNetworkImg} alt='' />
                </a>
            </span>
        );
    }
}
