import React from 'react';

import {RadioCheckbox, RadioCheckboxOption, RadioCheckboxValues} from '../uikit/RadioCheckbox';
import {FieldProps} from '../../types/FieldProps';
import {MultiselectFieldConfig} from '../../types/FieldsData';
import {getOptionsFromValues} from '../../utils/getOptionsFromValues';

export function MultiselectField(props: FieldProps<MultiselectFieldConfig>): React.ReactElement {
    const {
        data,
        onChange,
    } = props;

    const {
        name,
        value,
        values,
    } = data;

    const [options, setOptions] = React.useState<RadioCheckboxOption[]>([]);

    React.useEffect(() => {
        setOptions(getOptionsFromValues(values));
    }, [values]);

    const onChangeHandler = React.useCallback<(values: RadioCheckboxValues) => void>(values => {
        onChange(name, values as string[]);
    }, [onChange]);

    return (
        <RadioCheckbox
            options={options}
            values={value || []}
            multiselect
            onChange={onChangeHandler}
        />
    );
}
