import React from 'react';
import {LabelWithMiddleLink} from '../LabelWithMiddleLink';

import {Checkbox} from '../uikit/Checkbox';
import {FieldProps} from '../../types/FieldProps';
import {OfertaFieldConfig} from '../../types/FieldsData';

import {GLOSSARY} from './glossary';

export function OfertaField(props: FieldProps<OfertaFieldConfig>): React.ReactElement {
    const {
        data,
        onChange,
    } = props;

    const {
        name,
        value,
        url,
    } = data;

    const onChangeHandler = React.useCallback<React.ChangeEventHandler<HTMLInputElement>>(e => {
        onChange(name, e.target.checked);
    }, [onChange]);

    return (
        <Checkbox
            size='m'
            view='default'
            tone='direct'
            label={(
                <LabelWithMiddleLink
                    text={GLOSSARY.LABEL}
                    url={url}
                />
            )}
            checked={Boolean(value)}
            onChange={onChangeHandler}
        />
    );
}
