import React from 'react';

import {Select} from '../uikit/Select';
import {FieldProps} from '../../types/FieldProps';
import {SelectFieldConfig} from '../../types/FieldsData';
import {Textinput} from '../uikit/Textinput';

export function SelectField(props: FieldProps<SelectFieldConfig>): React.ReactElement {
    const {
        data,
        onChange,
    } = props;

    const {
        name,
        value,
        values,
    } = data;

    const onChangeHandler = React.useCallback<React.ChangeEventHandler<HTMLSelectElement>>(e => {
        onChange(name, e.target.value);
    }, [onChange]);

    if (values.length === 1 && name !== 'branch') {
        return (
            <Textinput
                size='m'
                view='default'
                value={value}
                disabled
            />
        );
    }

    return (
        <Select
            options={values}
            size='m'
            tone='direct'
            view='default'
            value={value}
            width='max'
            onChange={onChangeHandler}
        />
    );
}
