import React from 'react';
import {FieldsData} from '../../types/FieldsData';
import {Lang} from '../../types/Lang';
import {Form} from '../Form';
import {SimplePage} from '../SimplePage';

import {GLOSSARY} from './SimpleFormPageGlossary';

export interface SimpleFormPageStateProps {
    isPending: boolean;
    fieldsData: FieldsData;
    lang: Lang;
    submitButtonEnabled: boolean;
}

export interface SimpleFormPageDispatchProps {
    onSubmit: () => void;
    onFieldValueChange: (fieldName: string, value: string | string[] | boolean) => void;
}

type SimpleFormPageProps = SimpleFormPageStateProps & SimpleFormPageDispatchProps;

export function SimpleFormPage(props: SimpleFormPageProps) {
    const {
        fieldsData,
        lang,
        submitButtonEnabled,
        onSubmit,
        onFieldValueChange,
        isPending,
    } = props;

    const onSubmitHandler = React.useCallback(() => {
        onSubmit();
    }, [onSubmit]);

    return (
        <SimplePage
            isPending={isPending}
            title={GLOSSARY.TITLE}
            subtitle={GLOSSARY.SUBTITLE}
        >
            <Form
                fieldsData={fieldsData}
                lang={lang}
                submitButtonEnabled={submitButtonEnabled}
                onSubmit={onSubmitHandler}
                onFieldValueChange={onFieldValueChange}
            />
        </SimplePage>
    );
}
