import {FieldsData, FieldType} from '../../types/FieldsData';

export const TEMP_CONFIG: FieldsData = {
    fields: [{
        type: FieldType.Input,
        label: 'Фамилия',
        required: true,
        value: 'Иванов',
        name: 'cyrillic_last_name',
    }, {
        type: FieldType.Input,
        label: 'Имя',
        required: true,
        value: 'Иван',
        name: 'cyrillic_first_name',
    }, {
        type: FieldType.Input,
        label: 'Отчество',
        required: true,
        value: 'Иванович',
        name: 'cyrillic_patronymic_name',
    }, {
        type: FieldType.Input,
        label: 'Телефон',
        required: true,
        value: '+79089022993',
        name: 'phone',
    }, {
        type: FieldType.Input,
        label: 'E-mail',
        required: true,
        name: 'email',
    }, {
        type: FieldType.Select,
        label: 'Страна',
        required: true,
        name: 'country',
        values: [{
            content: 'Российская Федерация',
            value: '225',
        }, {
            content: 'Греция',
            value: '246',
        }],
    }, {
        type: FieldType.Select,
        label: 'Форма сотрудничества',
        required: true,
        name: 'org_type',
        values: [{
            content: 'Физическое лицо',
            value: 'russia_ph',
        }, {
            content: 'Юридическое лицо',
            value: 'russia_ur',
        }, {
            content: 'Индивидуальный предприниматель',
            value: 'russia_ip',
        }],
    }, {
        type: FieldType.Select,
        label: 'Валюта',
        required: true,
        name: 'currency',
        values: [{
            content: '$, USD',
            value: '2',
        }, {
            content: '₽, Рубль',
            value: '1',
        }],
    }, {
        type: FieldType.MultiSelect,
        label: 'Что вы хотите монетизировать?',
        required: true,
        value: ['site'],
        name: 'monetization',
        values: [{
            content: 'Сайт',
            value: 'site',
        }, {
            content: 'Мобильное приложение',
            value: 'app',
        }],
    }, {
        type: FieldType.Boolean,
        label: 'I agree to the processing and storage of my personal data. I accept the conditions by reading the text of the offer.',
        required: true,
        value: false,
        name: 'oferta_agreement',
    }, {
        type: FieldType.Boolean,
        label: 'Получать рассылку с полезными советами и рекомендациями',
        required: true,
        value: false,
        name: 'newsletter',
    }],
};
