import React from 'react';
import classnames from 'classnames';
import {cnTheme} from '@yandex-lego/components/Theme';

import {Text} from '../uikit/Text';
import {Spin} from '../uikit/Spin';
import {theme as directTheme} from '../../../themekit/presets/directTheme';

import css from './SimplePage.css';

type PageProps = React.PropsWithChildren<{
    title: string;
    subtitle: string;
    isPending: boolean;
}>;

const directThemeClassName = cnTheme(directTheme);

export function SimplePage(props: PageProps): React.ReactElement {
    const {
        isPending,
        title,
        subtitle,
        children,
    } = props;

    return (
        <div
            className={classnames(css.root, directThemeClassName)}
        >
            <div
                className={css.wrapper}
            >
                <div
                    className={css.header}
                >
                    <Text
                        typography='headline-s'
                    >
                        {title}
                    </Text>
                </div>
                <div
                    className={css.subHeader}
                >
                    <Text
                        className={css.subHeader__text}
                        typography='body-long-l'
                    >
                        {subtitle}
                    </Text>
                </div>
                <div
                    className={css.container}
                >
                    {children}
                    {isPending
                        ? <div className={css.curtain}>
                            <Spin
                                className={css.spin}
                                view='default'
                                size='l'
                                progress
                            />
                        </div>
                        : null
                    }
                </div>
            </div>
        </div>
    );
}
