import React from 'react';
import Markdown, {ComponentOverride} from 'markdown-to-jsx';
import {Link} from '../uikit/Link';

import {Text} from '../uikit/Text';

interface TextFieldProps {
    label: string;
}

const LINK_OVERRIDE: ComponentOverride = {
    component: Link,
    props: {
        view: 'default',
        target: '_blank',
    },
};

export function TextField(props: TextFieldProps): React.ReactElement {
    const {label} = props;

    return (
        <Text
            typography='body-long-l'
        >
            <Markdown
                options={{
                    overrides: {
                        a: LINK_OVERRIDE,
                    },
                }}
            >
                {label}
            </Markdown>
        </Text>
    );
}
