import React, {
    ElementType,
    KeyboardEventHandler,
    MouseEventHandler,
    ReactElement,
    ReactNode,
    Ref,
    RefObject,
} from 'react';
import {IconProps} from '../Icon';
import {KeyboardKeys, Pin} from '../types';
import {Button as ButtonDesktop} from './Button@desktop';

export type ContainerElement = HTMLButtonElement | HTMLAnchorElement;
export type IconProvider = (className: string) => ReactElement<IconProps>;
export type ButtonSize = 'l' | 'm' | 's' | 'xs' | 'tool' | 'xxs';

export interface ButtonStateProps {
    baseline?: boolean;
    pin?: Pin;
    size?: ButtonSize;
    /**
     * @deprecated
     * В новых местах и с кастомной темой нужно использовать свойство view!
     */
    theme?: 'action' | 'clear' | 'link' | 'normal' | 'pseudo' | 'raised' | 'websearch';
    type?: 'link' | 'submit' | 'calendar' | 'gap-icons';
    view?: 'default' | 'action' | 'clear' | 'link' | 'pseudo' | 'raised' | 'clear-white' | 'pseudo-white';
    width?: 'max' | 'auto';

    // For type link
    url?: string;
    target?: string;
    rel?: string;
    tabIndex?: number | string;
    title?: string;

    addonAfter?: ReactNode;
    addonBefore?: ReactNode;
    autoComplete?: string | null;
    checked?: boolean;
    icon?: IconProvider;
    iconLeft?: IconProvider;
    iconRight?: IconProvider;
    innerRef?: Ref<HTMLElement>;
    controlRef?: RefObject<ContainerElement>;
    pressKeys?: KeyboardKeys[];
    progress?: boolean;
    prvntKeys?: KeyboardKeys[];
    as?: ElementType;
    children?: ReactNode;
    disabled?: boolean;
    className?: string;
    id?: string;
}

export interface ButtonDispatchProps {
    onKeyDown?: KeyboardEventHandler<ContainerElement>;
    onKeyUp?: KeyboardEventHandler<ContainerElement>;
    onClick?: MouseEventHandler<ContainerElement>;
    onMouseDown?: MouseEventHandler<ContainerElement>;
}

export type ButtonProps = ButtonStateProps & ButtonDispatchProps;

export class Button extends React.PureComponent<ButtonProps> {
    public render() {
        return (
            <ButtonDesktop {...this.props}/>
        );
    }
}
