import {
    compose,
    composeU,
    ExtractProps,
} from '@bem-react/core';
import {
    Button as ButtonBase,
    IButtonProps as IButtonDesktopProps,
    withBaseline,
    withPinBrickBrick,
    withPinBrickCircle,
    withPinBrickClear,
    withPinBrickRound,
    withPinCircleBrick,
    withPinCircleCircle,
    withPinCircleClear,
    withPinClearBrick,
    withPinClearCircle,
    withPinClearClear,
    withPinClearRound,
    withPinRoundBrick,
    withPinRoundClear,
    withSizeL,
    withSizeM,
    withSizeS,
    withThemeAction,
    withThemeClear,
    withThemeLink,
    withThemeNormal,
    withThemePseudo,
    withThemeRaised,
    withThemeWebSearch,
    withTypeLink,
    withTypeSubmit,
    withViewAction,
    withViewClear,
    withViewDefault,
    withViewLink,
    withViewPseudo,
    withWidthAuto,
    withWidthMax,
} from '@yandex-lego/components/Button/desktop';
import {FC} from 'react';
import {withSizeTool} from './size/ButtonSizeTool';
import {withSizeXS} from './size/ButtonSizeXs';
import {withSizeXXS} from './size/ButtonSizeXxs';
import {withTypeCalendar} from './type/ButtonTypeCalendar';
import {withTypeGapIcons} from './type/ButtonTypeGapIcons';
import {withViewClearWhite} from './view/ButtonViewClearWhite';
import {withViewPseudoWhite} from './view/ButtonViewPseudoWhite';

interface IButtonProps extends IButtonDesktopProps {
    baseline?: boolean;
    pin?:
        | 'brick-brick'
        | 'brick-circle'
        | 'brick-clear'
        | 'brick-round'
        | 'circle-brick'
        | 'circle-circle'
        | 'circle-clear'
        | 'clear-brick'
        | 'clear-circle'
        | 'clear-clear'
        | 'clear-round'
        | 'round-brick'
        | 'round-clear';
    size?: 'l' | 'm' | 's' | 'xs' | 'xxs' | 'tool';
    theme?: 'action' | 'clear' | 'link' | 'normal' | 'pseudo' | 'raised' | 'websearch';
    type?: 'link' | 'submit' | 'calendar' | 'gap-icons';
    view?: 'default' | 'action' | 'clear' | 'link' | 'pseudo' | 'raised' | 'clear-white' | 'pseudo-white';
    width?: 'max' | 'auto';

    // For type link
    url?: string;
    target?: string;
    rel?: string;
    href?: string;
    tabIndex?: number | string;
}

export const Button = compose(
    composeU(
        withPinBrickBrick,
        withPinBrickCircle,
        withPinBrickClear,
        withPinBrickRound,
        withPinCircleBrick,
        withPinCircleCircle,
        withPinCircleClear,
        withPinClearBrick,
        withPinClearCircle,
        withPinClearClear,
        withPinClearRound,
        withPinRoundBrick,
        withPinRoundClear,
    ),
    composeU(withSizeL, withSizeM, withSizeS, withSizeTool, withSizeXS, withSizeXXS),
    composeU(
        withThemeAction,
        withThemeClear,
        withThemeLink,
        withThemeNormal,
        withThemePseudo,
        withThemeRaised,
        withThemeWebSearch,
    ),
    composeU(withTypeLink, withTypeSubmit, withTypeCalendar, withTypeGapIcons),
    composeU(withWidthAuto, withWidthMax),
    composeU(
        withViewDefault,
        withViewAction,
        withViewClear,
        withViewLink,
        withViewPseudo,
        withViewClearWhite,
        withViewPseudoWhite,
    ),
    withBaseline,
)(ButtonBase) as FC<IButtonProps>;

export type ButtonProps = ExtractProps<typeof Button>;
